/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TransferQueue;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.exception.Exceptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ReflectionsTest {
    @Test
    void toString_flatPackagePrintOptionSwitching() {
        Assertions.assertThat((String)Reflections.toString(String.class)).isEqualTo("j.l.String");
        Reflections.PACKAGES_PRINT_MODE_CONTEXT.set(Optional.of("off"));
        Assertions.assertThat((String)Reflections.toString(String.class)).isEqualTo("java.lang.String");
        Reflections.PACKAGES_PRINT_MODE_CONTEXT.remove();
        Assertions.assertThat((String)Reflections.toString(String.class)).isEqualTo("j.l.String");
        Reflections.PACKAGES_PRINT_MODE_CONTEXT.set(Optional.of("off"));
        Reflections.PACKAGES_PRINT_MODE_CONTEXT.remove();
        Assertions.assertThat((String)Reflections.toString(String.class)).isEqualTo("j.l.String");
        Reflections.PACKAGES_PRINT_MODE_CONTEXT.set(Optional.of("false"));
        Reflections.PACKAGES_PRINT_MODE_CONTEXT.remove();
        Assertions.assertThat((String)Reflections.toString(String.class)).isEqualTo("j.l.String");
    }

    @Test
    void getDefaultConstructor() {
        Constructor defaultConstructor = Reflections.getDefaultConstructor(Toto.class);
        Assertions.assertThat((Object)defaultConstructor).isNotNull();
    }

    @Test
    void getDefaultConstructor_closedClass() {
        Constructor defaultConstructor = Reflections.getDefaultConstructor(ClosedClass.class);
        Assertions.assertThat((Object)defaultConstructor).isNotNull();
    }

    @Test
    void getDefaultConstructor_innerStaticClass() {
        Constructor defaultConstructor = Reflections.getDefaultConstructor(InnerStaticClass.class);
        Assertions.assertThat((Object)defaultConstructor).isNotNull();
    }

    @Test
    void getDefaultConstructor_abstractClass() {
        Constructor defaultConstructor = Reflections.getDefaultConstructor(AbstractMap.class);
        Assertions.assertThat((Object)defaultConstructor).isNotNull();
    }

    public static Object[][] testGetDefaultConstructor_throwingCases_data() {
        return new Object[][]{{InnerClass.class, "Class o.c.t.ReflectionsTest$InnerClass has no default constructor because it is an inner non static class (needs an instance of the enclosing class to be constructed)"}, {Integer.TYPE, "Class int has no default constructor because it is a primitive type"}, {int[].class, "Class int[] has no default constructor because it is an array"}, {CharSequence.class, "Class j.l.CharSequence has no default constructor because it is an interface"}, {URL.class, "Class j.n.URL has no default constructor"}};
    }

    @ParameterizedTest
    @MethodSource(value={"testGetDefaultConstructor_throwingCases_data"})
    void getDefaultConstructor_throwingCases(Class<?> clazz, String expectedMessage) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Reflections.getDefaultConstructor((Class)clazz)).isInstanceOf(UnsupportedOperationException.class)).hasMessage(expectedMessage);
    }

    @Test
    void getConstructor_private() {
        Constructor constructor1 = Reflections.getConstructor(InnerStaticClassWithPrivateConstructor.class, (Class[])new Class[0]);
        Assertions.assertThat((Object)constructor1).isNotNull();
        Constructor constructor2 = Reflections.getConstructor(InnerClassWithPrivateConstructor.class, (Class[])new Class[]{ReflectionsTest.class});
        Assertions.assertThat((Object)constructor2).isNotNull();
    }

    @Test
    void getConstructor_innerNonStaticClass_missingEnclosingClassAsParameter_throwsException() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Reflections.getConstructor(InnerClassWithPrivateConstructor.class, (Class[])new Class[0])).isInstanceOf(Reflections.MemberNotFoundException.class)).hasMessage("Non static inner classes require an enclosing class parameter as first argument");
    }

    public static Object[][] testGetFieldData() {
        return new Object[][]{{Toto.class, "a", Toto.class}, {Toto.class, "b", Toto.class}, {Tutu.class, "a", Toto.class}, {Tutu.class, "b", Tata.class}};
    }

    @ParameterizedTest
    @MethodSource(value={"testGetFieldData"})
    void getField(Class<Toto> fieldClass, String fieldName, Class expectedDeclaringClass) {
        Field field = Reflections.findField(fieldClass, (String)fieldName);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo(fieldName);
        Assertions.assertThat(field.getDeclaringClass()).isEqualTo((Object)expectedDeclaringClass);
    }

    public static Object[][] findGetMethodData() {
        return new Object[][]{{Toto.class, "toto", null, Toto.class, 0}, {Toto.class, "toto2", null, Toto.class, 0}, {Toto.class, "toto", Integer.TYPE, Toto.class, 1}, {Toto.class, "toto2", Integer.TYPE, Toto.class, 1}, {Toto.class, "setA", Integer.class, Toto.class, 1}, {Toto.class, "setC", String.class, Toto.class, 1}, {Toto.class, "setC", StringBuffer.class, Toto.class, 1}, {Tutu.class, "toto", null, Toto.class, 0}, {Tutu.class, "toto2", null, Toto.class, 0}, {Tutu.class, "toto", Integer.TYPE, Toto.class, 1}, {Tutu.class, "toto2", Integer.TYPE, Toto.class, 1}};
    }

    @ParameterizedTest
    @MethodSource(value={"findGetMethodData"})
    void findMethod(Class<Toto> methodClass, String methodName, Class parameterType, Class expectedDeclaringClass, int expectedParameterCount) {
        Method method = parameterType == null ? Reflections.findMethod(methodClass, (String)methodName, (Class[])new Class[0]) : Reflections.findMethod(methodClass, (String)methodName, (Class[])new Class[]{parameterType});
        Assertions.assertThat((Object)method).isNotNull();
        Assertions.assertThat((String)method.getName()).isEqualTo(methodName);
        Assertions.assertThat(method.getDeclaringClass()).isEqualTo((Object)expectedDeclaringClass);
        Assertions.assertThat((int)method.getParameterTypes().length).isEqualTo(expectedParameterCount);
    }

    @Test
    void getConstructor() throws NoSuchMethodException {
        Assertions.assertThat((Object)Reflections.getConstructor(String.class, (Class[])new Class[]{String.class})).isEqualTo(String.class.getConstructor(String.class));
        Assertions.assertThatThrownBy(() -> Reflections.getConstructor(String.class, (Class[])new Class[]{Reflections.class})).isInstanceOf(Reflections.MemberNotFoundException.class);
    }

    @Test
    void findConstructor() throws NoSuchMethodException {
        Assertions.assertThat((Object)Reflections.findConstructor(String.class, (Class[])new Class[]{String.class})).isEqualTo(String.class.getConstructor(String.class));
        Assertions.assertThat((Object)Reflections.findConstructor(String.class, (Class[])new Class[]{Reflections.class})).isNull();
    }

    @Test
    void onJavaBeanPropertyWrapperName_getterIsRecognized() throws NoSuchMethodException {
        class X {
            X() {
            }

            void getA() {
            }
        }
        boolean found = (Boolean)Reflections.onJavaBeanPropertyWrapperName((Method)X.class.getDeclaredMethod("getA", new Class[0]), m -> true, m -> false, m -> false);
        Assertions.assertThat((boolean)found).isTrue();
    }

    @Test
    void onJavaBeanPropertyWrapperName_getterIsRecognized_boolean() throws NoSuchMethodException {
        class X {
            X() {
            }

            void isA() {
            }
        }
        boolean found = (Boolean)Reflections.onJavaBeanPropertyWrapperName((Method)X.class.getDeclaredMethod("isA", new Class[0]), m -> false, m -> false, m -> true);
        Assertions.assertThat((boolean)found).isTrue();
    }

    @Test
    void onJavaBeanPropertyWrapperName_setterIsRecognized() throws NoSuchMethodException {
        class X {
            X() {
            }

            void setA() {
            }
        }
        boolean found = (Boolean)Reflections.onJavaBeanPropertyWrapperName((Method)X.class.getDeclaredMethod("setA", new Class[0]), m -> false, m -> true, m -> false);
        Assertions.assertThat((boolean)found).isTrue();
    }

    @Test
    void onJavaBeanPropertyWrapperName_doesntMatchJavaBeanStandard_throwsException() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Boolean cfr_ignored_0 = (Boolean)Reflections.onJavaBeanPropertyWrapperName((Method)String.class.getMethod("toString", new Class[0]), m -> false, m -> true, m -> false);
        }).isInstanceOf(Reflections.MemberNotFoundException.class)).hasMessage("Field wrapper j.l.String.toString() doesn't fit encapsulation naming convention");
    }

    @Test
    void onJavaBeanPropertyWrapperName_inputMethodName_getterIsRecognized() {
        boolean found = (Boolean)Reflections.onJavaBeanPropertyWrapperName((String)"getA", m -> true, m -> false, m -> false);
        Assertions.assertThat((boolean)found).isTrue();
    }

    @Test
    void onJavaBeanPropertyWrapperName_inputMethodName_getterIsRecognized_boolean() {
        boolean found = (Boolean)Reflections.onJavaBeanPropertyWrapperName((String)"isA", m -> false, m -> false, m -> true);
        Assertions.assertThat((boolean)found).isTrue();
    }

    @Test
    void onJavaBeanPropertyWrapperName_inputMethodName_setterIsRecognized() {
        boolean found = (Boolean)Reflections.onJavaBeanPropertyWrapperName((String)"setA", m -> false, m -> true, m -> false);
        Assertions.assertThat((boolean)found).isTrue();
    }

    @Test
    void onJavaBeanPropertyWrapperName_inputMethodName_doesntMatchJavaBeanStandard_throwsException() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Boolean cfr_ignored_0 = (Boolean)Reflections.onJavaBeanPropertyWrapperName((String)"doSomething", m -> false, m -> true, m -> false);
        }).isInstanceOf(Reflections.MemberNotFoundException.class)).hasMessage("Field wrapper doSomething doesn't fit encapsulation naming convention");
    }

    @Test
    void onJavaBeanPropertyWrapper_getterIsRecognized() throws NoSuchMethodException {
        class X {
            X() {
            }

            String getA() {
                return null;
            }
        }
        boolean found = (Boolean)Reflections.onJavaBeanPropertyWrapper((Method)X.class.getDeclaredMethod("getA", new Class[0]), m -> true, m -> false, m -> false);
        Assertions.assertThat((boolean)found).isTrue();
    }

    @Test
    void onJavaBeanPropertyWrapper_getterIsRecognized_boolean() throws NoSuchMethodException {
        class X {
            X() {
            }

            boolean isA() {
                return true;
            }
        }
        boolean found = (Boolean)Reflections.onJavaBeanPropertyWrapper((Method)X.class.getDeclaredMethod("isA", new Class[0]), m -> false, m -> false, m -> true);
        Assertions.assertThat((boolean)found).isTrue();
    }

    @Test
    void onJavaBeanPropertyWrapper_setterIsRecognized() throws NoSuchMethodException {
        class X {
            X() {
            }

            void setA(String a) {
            }
        }
        boolean found = (Boolean)Reflections.onJavaBeanPropertyWrapper((Method)X.class.getDeclaredMethod("setA", String.class), m -> false, m -> true, m -> false);
        Assertions.assertThat((boolean)found).isTrue();
    }

    @Test
    void newBeanInstance_class_privateConstructor() {
        ClosedClass closedClass = (ClosedClass)Reflections.newBeanInstance(ClosedClass.class);
        Assertions.assertThat((Object)closedClass).isNotNull();
    }

    @Test
    void newBeanInstance_interface_throwsException() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            CharSequence cfr_ignored_0 = (CharSequence)Reflections.newBeanInstance(CharSequence.class);
        }).isInstanceOf(Reflections.InvokationRuntimeException.class)).extracting(thrownException -> (UnsupportedOperationException)Exceptions.findExceptionInCauses((Throwable)thrownException, UnsupportedOperationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Class j.l.CharSequence has no default constructor because it is an interface");
    }

    @Test
    void newBeanInstance_abstractClass_throwsException() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            AbstractClass cfr_ignored_0 = (AbstractClass)Reflections.newBeanInstance(AbstractClass.class);
        }).isInstanceOf(Reflections.InvokationRuntimeException.class)).extracting(thrownException -> (Reflections.InvokationRuntimeException)Exceptions.findExceptionInCauses((Throwable)thrownException, Reflections.InvokationRuntimeException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Class o.c.t.ReflectionsTest$AbstractClass can't be instantiated because it is abstract");
    }

    @Test
    void newBeanInstance_classWhichConstructorThrowsException_throwsException() {
        AbstractThrowableAssert exceptionAsserter = (AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            ThrowingConstructorClass cfr_ignored_0 = (ThrowingConstructorClass)Reflections.newBeanInstance(ThrowingConstructorClass.class);
        }).isInstanceOf(Reflections.InvokationRuntimeException.class);
        ((AbstractThrowableAssert)exceptionAsserter.extracting(thrownException -> (Reflections.InvokationRuntimeException)Exceptions.findExceptionInCauses((Throwable)thrownException, Reflections.InvokationRuntimeException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Class o.c.t.ReflectionsTest$ThrowingConstructorClass can't be instantiated");
        ((AbstractThrowableAssert)exceptionAsserter.extracting(thrownException -> (NullPointerException)Exceptions.findExceptionInCauses((Throwable)thrownException, NullPointerException.class), InstanceOfAssertFactories.THROWABLE)).isNotNull();
    }

    static Stream<Arguments> newCollectionInstance_data() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{SortedSet.class, TreeSet.class}), Arguments.arguments((Object[])new Object[]{Set.class, HashSet.class}), Arguments.arguments((Object[])new Object[]{LinkedHashSet.class, LinkedHashSet.class}), Arguments.arguments((Object[])new Object[]{KeepOrderSet.class, KeepOrderSet.class}), Arguments.arguments((Object[])new Object[]{List.class, ArrayList.class}), Arguments.arguments((Object[])new Object[]{LinkedList.class, LinkedList.class}), Arguments.arguments((Object[])new Object[]{Queue.class, ArrayDeque.class}), Arguments.arguments((Object[])new Object[]{BlockingDeque.class, LinkedBlockingDeque.class}), Arguments.arguments((Object[])new Object[]{BlockingQueue.class, ArrayBlockingQueue.class}), Arguments.arguments((Object[])new Object[]{TransferQueue.class, LinkedTransferQueue.class}));
    }

    @ParameterizedTest
    @MethodSource(value={"newCollectionInstance_data"})
    void newCollectionInstance(Class<? extends Collection> collectionType, Class<? extends Collection> expectedType) {
        Collection instance = Reflections.newCollectionInstance(collectionType);
        Assertions.assertThat((Collection)instance).isInstanceOf(expectedType);
    }

    static Stream<Arguments> newMapInstance_data() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{SortedMap.class, TreeMap.class}), Arguments.arguments((Object[])new Object[]{Map.class, HashMap.class}), Arguments.arguments((Object[])new Object[]{LinkedHashMap.class, LinkedHashMap.class}));
    }

    @ParameterizedTest
    @MethodSource(value={"newMapInstance_data"})
    void newMapInstance(Class<? extends Map> collectionType, Class<? extends Map> expectedType) {
        Map instance = Reflections.newMapInstance(collectionType);
        Assertions.assertThat((Map)instance).isInstanceOf(expectedType);
    }

    @Test
    void newInstance() {
        List listInstance = (List)Reflections.newInstance(List.class);
        Assertions.assertThat((List)listInstance).isInstanceOf(ArrayList.class);
        Set setInstance = (Set)Reflections.newInstance(Set.class);
        Assertions.assertThat((Collection)setInstance).isInstanceOf(HashSet.class);
        Queue queueInstance = (Queue)Reflections.newInstance(Queue.class);
        Assertions.assertThat((Collection)queueInstance).isInstanceOf(ArrayDeque.class);
        Map mapInstance = (Map)Reflections.newInstance(Map.class);
        Assertions.assertThat((Map)mapInstance).isInstanceOf(HashMap.class);
        ClosedClass beanInstance = (ClosedClass)Reflections.newInstance(ClosedClass.class);
        Assertions.assertThat((Object)beanInstance).isInstanceOf(ClosedClass.class);
    }

    @Test
    void newInstance_constructor() throws NoSuchMethodException {
        Assertions.assertThat((String)((String)Reflections.newInstance(String.class.getConstructor(new Class[0]), (Object[])new Object[0]))).isEqualTo("");
        Assertions.assertThat((String)((String)Reflections.newInstance(String.class.getConstructor(byte[].class), (Object[])new Object[]{new byte[]{65, 66}}))).isEqualTo("AB");
    }

    @Test
    void newInstance_constructor_throwsException_throwsException() {
        AbstractThrowableAssert exceptionAsserter = (AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            ThrowingConstructorClass cfr_ignored_0 = (ThrowingConstructorClass)Reflections.newInstance(ThrowingConstructorClass.class.getConstructor(new Class[0]), (Object[])new Object[0]);
        }).isInstanceOf(Reflections.InvokationRuntimeException.class);
        ((AbstractThrowableAssert)exceptionAsserter.extracting(thrownException -> (Reflections.InvokationRuntimeException)Exceptions.findExceptionInCauses((Throwable)thrownException, Reflections.InvokationRuntimeException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Class o.c.t.ReflectionsTest$ThrowingConstructorClass can't be instantiated");
        ((AbstractThrowableAssert)exceptionAsserter.extracting(thrownException -> (NullPointerException)Exceptions.findExceptionInCauses((Throwable)thrownException, NullPointerException.class), InstanceOfAssertFactories.THROWABLE)).isNotNull();
    }

    @Test
    void invoke() throws NoSuchMethodException {
        Toto toto = new Toto();
        Method setter = Toto.class.getMethod("setA", Integer.TYPE);
        Reflections.invoke((Method)setter, (Object)toto, (Object[])new Object[]{42});
        Assertions.assertThat((int)toto.getA()).isEqualTo(42);
        Assertions.assertThatThrownBy(() -> Reflections.invoke((Method)setter, (Object)toto, (Object[])new Object[]{"dummyString"})).isInstanceOf(Reflections.InvokationRuntimeException.class);
        Method privateMethod = Toto.class.getDeclaredMethod("toto", new Class[0]);
        Assertions.assertThatThrownBy(() -> Reflections.invoke((Method)privateMethod, (Object)toto, (Object[])new Object[0])).isInstanceOf(Reflections.InvokationRuntimeException.class);
    }

    @Test
    void wrappedField() throws NoSuchMethodException, NoSuchFieldException {
        Field field = Reflections.wrappedField((Method)Toto.class.getDeclaredMethod("setB", String.class));
        Assertions.assertThat((Object)field).isEqualTo((Object)Toto.class.getDeclaredField("b"));
        field = Reflections.wrappedField((Method)Tata.class.getDeclaredMethod("setB", String.class));
        Assertions.assertThat((Object)field).isEqualTo((Object)Tata.class.getDeclaredField("b"));
        field = Reflections.wrappedField((Method)Tata.class.getDeclaredMethod("setA", Integer.TYPE));
        Assertions.assertThat((Object)field).isEqualTo((Object)Toto.class.getDeclaredField("a"));
    }

    @Test
    void propertyName() throws NoSuchMethodException {
        String propertyName = Reflections.propertyName((Method)Toto.class.getDeclaredMethod("setB", String.class));
        Assertions.assertThat((String)propertyName).isEqualTo("b");
    }

    @Test
    void propertyName_methodDoesntFitJavaBeanConvention_exceptionIsThrown() throws NoSuchMethodException {
        Method fixBMethod = Toto.class.getDeclaredMethod("fixB", String.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Reflections.propertyName((Method)fixBMethod)).isInstanceOf(Reflections.MemberNotFoundException.class)).hasMessage("Field wrapper o.c.t.ReflectionsTest$Toto.fixB(j.l.String) doesn't fit encapsulation naming convention");
    }

    @Test
    void forName() {
        Assertions.assertThat((Class)Reflections.forName((String)"Z")).isEqualTo(Boolean.TYPE);
        Assertions.assertThat((Class)Reflections.forName((String)"I")).isEqualTo(Integer.TYPE);
        Assertions.assertThat((Class)Reflections.forName((String)"J")).isEqualTo(Long.TYPE);
        Assertions.assertThat((Class)Reflections.forName((String)"S")).isEqualTo(Short.TYPE);
        Assertions.assertThat((Class)Reflections.forName((String)"B")).isEqualTo(Byte.TYPE);
        Assertions.assertThat((Class)Reflections.forName((String)"D")).isEqualTo(Double.TYPE);
        Assertions.assertThat((Class)Reflections.forName((String)"F")).isEqualTo(Float.TYPE);
        Assertions.assertThat((Class)Reflections.forName((String)"C")).isEqualTo(Character.TYPE);
        Assertions.assertThat((Class)Reflections.forName((String)"V")).isEqualTo(Void.TYPE);
        Assertions.assertThat((Class)Reflections.forName((String)String.class.getName())).isEqualTo(String.class);
        Assertions.assertThat((Class)Reflections.forName((String)"[Ljava.lang.Object;")).isEqualTo(Object[].class);
        Assertions.assertThat((Class)Reflections.forName((String)"Ljava.lang.Object;")).isEqualTo(Object.class);
        Assertions.assertThat((Class)Reflections.forName((String)"java.lang.Object")).isEqualTo(Object.class);
        Assertions.assertThat((Class)Reflections.forName((String)"[Z")).isEqualTo(boolean[].class);
        Assertions.assertThat((Class)Reflections.forName((String)"[[Z")).isEqualTo(boolean[][].class);
    }

    @Test
    void wrapperClass() {
        Assertions.assertThat((Class)Reflections.giveWrapperClass(Boolean.TYPE)).isEqualTo(Boolean.class);
        Assertions.assertThat((Class)Reflections.giveWrapperClass(Integer.TYPE)).isEqualTo(Integer.class);
        Assertions.assertThat((Class)Reflections.giveWrapperClass(Long.TYPE)).isEqualTo(Long.class);
        Assertions.assertThat((Class)Reflections.giveWrapperClass(Short.TYPE)).isEqualTo(Short.class);
        Assertions.assertThat((Class)Reflections.giveWrapperClass(Byte.TYPE)).isEqualTo(Byte.class);
        Assertions.assertThat((Class)Reflections.giveWrapperClass(Double.TYPE)).isEqualTo(Double.class);
        Assertions.assertThat((Class)Reflections.giveWrapperClass(Float.TYPE)).isEqualTo(Float.class);
        Assertions.assertThat((Class)Reflections.giveWrapperClass(Character.TYPE)).isEqualTo(Character.class);
        Assertions.assertThat((Class)Reflections.giveWrapperClass(Void.TYPE)).isEqualTo(Void.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Reflections.giveWrapperClass(String.class)).extracting(throwException -> (IllegalArgumentException)Exceptions.findExceptionInCauses((Throwable)throwException, IllegalArgumentException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Given type is not a primitive one : j.l.String");
    }

    @Test
    void isPrimitive() {
        Assertions.assertThat((boolean)Reflections.isPrimitiveType(Boolean.TYPE)).isTrue();
        Assertions.assertThat((boolean)Reflections.isPrimitiveType(Integer.TYPE)).isTrue();
        Assertions.assertThat((boolean)Reflections.isPrimitiveType(Long.TYPE)).isTrue();
        Assertions.assertThat((boolean)Reflections.isPrimitiveType(Short.TYPE)).isTrue();
        Assertions.assertThat((boolean)Reflections.isPrimitiveType(Byte.TYPE)).isTrue();
        Assertions.assertThat((boolean)Reflections.isPrimitiveType(Double.TYPE)).isTrue();
        Assertions.assertThat((boolean)Reflections.isPrimitiveType(Float.TYPE)).isTrue();
        Assertions.assertThat((boolean)Reflections.isPrimitiveType(Character.TYPE)).isTrue();
        Assertions.assertThat((boolean)Reflections.isPrimitiveType(Void.TYPE)).isTrue();
        Assertions.assertThat((boolean)Reflections.isPrimitiveType(Object.class)).isFalse();
    }

    @Test
    void isComplexType() {
        Assertions.assertThat((boolean)Reflections.isComplexType(Boolean.TYPE)).isFalse();
        Assertions.assertThat((boolean)Reflections.isComplexType(Integer.TYPE)).isFalse();
        Assertions.assertThat((boolean)Reflections.isComplexType(Long.TYPE)).isFalse();
        Assertions.assertThat((boolean)Reflections.isComplexType(Short.TYPE)).isFalse();
        Assertions.assertThat((boolean)Reflections.isComplexType(Byte.TYPE)).isFalse();
        Assertions.assertThat((boolean)Reflections.isComplexType(Double.TYPE)).isFalse();
        Assertions.assertThat((boolean)Reflections.isComplexType(Float.TYPE)).isFalse();
        Assertions.assertThat((boolean)Reflections.isComplexType(Character.TYPE)).isFalse();
        Assertions.assertThat((boolean)Reflections.isComplexType(Void.TYPE)).isFalse();
        Assertions.assertThat((boolean)Reflections.isComplexType(Object.class)).isTrue();
    }

    @Test
    void isAssignableFrom() {
        Assertions.assertThat((boolean)Reflections.isAssignableFrom(Boolean.TYPE, Boolean.class)).isTrue();
        Assertions.assertThat((boolean)Reflections.isAssignableFrom(Boolean.class, Boolean.TYPE)).isTrue();
        Assertions.assertThat((boolean)Reflections.isAssignableFrom(CharSequence.class, String.class)).isTrue();
        Assertions.assertThat((boolean)Reflections.isAssignableFrom(String.class, CharSequence.class)).isFalse();
        Assertions.assertThat((boolean)Reflections.isAssignableFrom(String.class, String.class)).isTrue();
        Assertions.assertThat((boolean)Reflections.isAssignableFrom(CharSequence.class, CharSequence.class)).isTrue();
        Assertions.assertThat((boolean)Reflections.isAssignableFrom(CharSequence.class, Object.class)).isFalse();
        Assertions.assertThat((boolean)Reflections.isAssignableFrom(Object.class, CharSequence.class)).isTrue();
    }

    @Test
    void newProxy() throws NoSuchMethodException, IOException {
        Method[] capturedMethod = new Method[1];
        CharSequence proxy = (CharSequence)Reflections.newProxy(CharSequence.class, (p, m, args) -> {
            capturedMethod[0] = m;
            return null;
        }, (Class[])new Class[]{Closeable.class});
        proxy.subSequence(0, 1);
        Assertions.assertThat((Object)capturedMethod[0]).isEqualTo((Object)CharSequence.class.getMethod("subSequence", Integer.TYPE, Integer.TYPE));
        ((Closeable)((Object)proxy)).close();
        Assertions.assertThat((Object)capturedMethod[0]).isEqualTo((Object)Closeable.class.getMethod("close", new Class[0]));
    }

    @Test
    void isStatic_class() {
        Assertions.assertThat((boolean)Reflections.isStatic(InnerClass.class)).isFalse();
        Assertions.assertThat((boolean)Reflections.isStatic(InnerStaticClass.class)).isTrue();
    }

    @Test
    void isStatic_method() {
        Assertions.assertThat((boolean)Reflections.isStatic((Method)Reflections.getMethod(Objects.class, (String)"equals", (Class[])new Class[]{Object.class, Object.class}))).isTrue();
        Assertions.assertThat((boolean)Reflections.isStatic((Method)Reflections.getMethod(Object.class, (String)"equals", (Class[])new Class[]{Object.class}))).isFalse();
    }

    @Test
    void isStatic_field() {
        Assertions.assertThat((boolean)Reflections.isStatic((Field)Reflections.getField(String.class, (String)"CASE_INSENSITIVE_ORDER"))).isTrue();
        Assertions.assertThat((boolean)Reflections.isStatic((Field)Reflections.getField(String.class, (String)"value"))).isFalse();
    }

    private static abstract class AbstractClass {
        private AbstractClass() {
        }
    }

    private static class ThrowingConstructorClass {
        public ThrowingConstructorClass() {
            throw new NullPointerException();
        }
    }

    private static class InnerStaticClassWithPrivateConstructor {
        private InnerStaticClassWithPrivateConstructor() {
        }
    }

    private static class InnerStaticClass {
        private InnerStaticClass() {
        }
    }

    private class InnerClassWithPrivateConstructor {
        private InnerClassWithPrivateConstructor() {
        }
    }

    private class InnerClass {
        private InnerClass() {
        }
    }

    private static class Tutu
    extends Titi {
        private Tutu() {
        }
    }

    private static class Titi
    extends Tata {
        private Titi() {
        }
    }

    private static class Tata
    extends Toto {
        private String b;

        private Tata() {
        }

        @Override
        public void setA(int a) {
            super.setA(a);
        }

        @Override
        public void setB(String b) {
            this.b = b;
        }
    }

    private static class Toto {
        private int a;
        private String b;

        private Toto() {
        }

        private void toto() {
        }

        private void toto(int a) {
        }

        private void toto2(int a) {
        }

        private void toto2() {
        }

        public int getA() {
            return this.a;
        }

        public void setA(int a) {
            this.a = a;
        }

        public void setB(String b) {
            this.b = b;
        }

        public void fixB(String b) {
            this.setB(b);
        }

        public void setC(CharSequence s) {
        }
    }

    private static class ClosedClass {
        private ClosedClass() {
        }
    }
}

